<x-platform-layout>
    <div class="md:pt-12 border-t">
        <section class="max-w-7xl mx-auto sm:px-6 lg:px-8 md:mb-20">
            <div class="relative bg-white overflow-hidden shadow-lg">
                <div class="max-w-7xl mx-auto">
                    <div class="relative z-10 pb-8 bg-white sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                        <svg class="hidden lg:block absolute right-0 inset-y-0 h-full w-48 text-white transform translate-x-1/2"
                            fill="currentColor" viewBox="0 0 100 100" preserveAspectRatio="none" aria-hidden="true">
                            <polygon points="50,0 100,0 50,100 0,100" />
                        </svg>

                        <div class="relative pt-6 px-4 sm:px-6 lg:px-8">

                        </div>

                        <main class="mt-10 mx-auto max-w-7xl px-4 sm:mt-12 sm:px-6 md:mt-16 lg:mt-20 lg:px-8 xl:mt-28">
                            <div class="sm:text-center lg:text-left">
                                <h1
                                    class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl">
                                    <span class="block xl:inline">Saúde Mental</span>
                                    <span class="block text-primary-800 xl:inline">encontre um especialista</span>
                                </h1>
                                <p
                                    class="mt-3 text-base text-gray-500 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0">
                                    Psicólogos(as), Médicos(as) e outros profissionais online. Acolhimento, respeito,
                                    humanização, espiritualidade
                                </p>
                                <div class="mt-5 sm:mt-8 sm:flex sm:justify-center lg:justify-start">
                                    <div class="rounded-md shadow">
                                        <a href="#"
                                            class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 md:py-4 md:text-lg md:px-10">
                                            Encontrar especialista
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </main>
                    </div>
                </div>
                <div class="lg:absolute lg:inset-y-0 lg:right-0 lg:w-1/2">
                    <img class="h-56 w-full object-cover sm:h-72 md:h-96 lg:w-full lg:h-full"
                        src="https://st2.depositphotos.com/3662505/7656/i/600/depositphotos_76566549-stock-photo-psychotherapy.jpg"
                        alt="">
                </div>
            </div>
        </section>
        <section class="bg-white overflow-hidden border-t">
            <div class="relative max-w-7xl mx-auto py-16 px-4 sm:px-6 lg:px-8">
                <div class="hidden lg:block bg-gray-50 absolute top-0 bottom-0 left-3/4 w-screen"></div>
                <div class="mx-auto text-base max-w-prose lg:max-w-none">
                    <h3 class="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-brSecondary-dark sm:text-4xl">
                        BioReligare
                    </h3>
                </div>
                <div class="mt-8 lg:grid lg:grid-cols-2 lg:gap-8">
                    <div class="relative lg:row-start-1 lg:col-start-2">
                        <svg class="hidden lg:block absolute top-0 right-0 -mt-20 -mr-20" width="404" height="384"
                            fill="none" viewBox="0 0 404 384" aria-hidden="true">
                            <defs>
                                <pattern id="de316486-4a29-4312-bdfc-fbce2132a2c1" x="0" y="0" width="20" height="20"
                                    patternUnits="userSpaceOnUse">
                                    <rect x="0" y="0" width="4" height="4" class="text-gray-200" fill="currentColor" />
                                </pattern>
                            </defs>
                            <rect width="404" height="384" fill="url(#de316486-4a29-4312-bdfc-fbce2132a2c1)" />
                        </svg>
                        <div class="relative text-base mx-auto max-w-prose lg:max-w-none">
                            <figure>
                                <div class="aspect-w-12 aspect-h-7 lg:aspect-none">
                                    <img class="rounded-lg shadow-lg object-cover object-center"
                                        src="https://images.unsplash.com/photo-1546913199-55e06682967e?ixlib=rb-1.2.1&auto=format&fit=crop&crop=focalpoint&fp-x=.735&fp-y=.55&w=1184&h=1376&q=80"
                                        alt="Whitney leaning against a railing on a downtown street" width="1184"
                                        height="1376">
                                </div>
                                <figcaption class="mt-3 flex text-sm text-gray-500">
                                    <!-- Heroicon name: solid/camera -->
                                    <svg class="flex-none w-5 h-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                        viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                        <path fill-rule="evenodd"
                                            d="M4 5a2 2 0 00-2 2v8a2 2 0 002 2h12a2 2 0 002-2V7a2 2 0 00-2-2h-1.586a1 1 0 01-.707-.293l-1.121-1.121A2 2 0 0011.172 3H8.828a2 2 0 00-1.414.586L6.293 4.707A1 1 0 015.586 5H4zm6 9a3 3 0 100-6 3 3 0 000 6z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </figcaption>
                            </figure>
                        </div>
                    </div>
                    <div class="mt-8 lg:mt-0">
                        <div class="text-base max-w-prose mx-auto lg:max-w-none">
                            <p class="text-lg text-gray-500">Sagittis scelerisque nulla cursus in enim consectetur quam.
                                Dictum urna sed consectetur neque tristique pellentesque. Blandit amet, sed aenean erat
                                arcu
                                morbi.</p>
                        </div>
                        <div
                            class="mt-5 prose prose-indigo text-gray-500 mx-auto lg:max-w-none lg:row-start-1 lg:col-start-1">
                            <p>Sollicitudin tristique eros erat odio sed vitae, consequat turpis elementum. Lorem nibh
                                vel,
                                eget pretium arcu vitae. Eros eu viverra donec ut volutpat donec laoreet quam urna.</p>
                            <p>Bibendum eu nulla feugiat justo, elit adipiscing. Ut tristique sit nisi lorem pulvinar.
                                Urna,
                                laoreet fusce nibh leo. Dictum et et et sit. Faucibus sed non gravida lectus dignissim
                                imperdiet a.</p>
                            <p>Dictum magnis risus phasellus vitae quam morbi. Quis lorem lorem arcu, metus, egestas
                                netus
                                cursus. In.</p>
                            <ul>
                                <li>Quis elit egestas venenatis mattis dignissim.</li>
                                <li>Cras cras lobortis vitae vivamus ultricies facilisis tempus.</li>
                                <li>Orci in sit morbi dignissim metus diam arcu pretium.</li>
                            </ul>
                            <p>Rhoncus nisl, libero egestas diam fermentum dui. At quis tincidunt vel ultricies.
                                Vulputate
                                aliquet velit faucibus semper. Pellentesque in venenatis vestibulum consectetur nibh id.
                                In
                                id ut tempus egestas. Enim sit aliquam nec, a. Morbi enim fermentum lacus in. Viverra.
                            </p>
                            <h3>How we helped</h3>
                            <p>Tincidunt integer commodo, cursus etiam aliquam neque, et. Consectetur pretium in
                                volutpat,
                                diam. Montes, magna cursus nulla feugiat dignissim id lobortis amet. Laoreet sem est
                                phasellus eu proin massa, lectus. Diam rutrum posuere donec ultricies non morbi. Mi a
                                platea
                                auctor mi.</p>
                            <p>Sagittis scelerisque nulla cursus in enim consectetur quam. Dictum urna sed consectetur
                                neque
                                tristique pellentesque. Blandit amet, sed aenean erat arcu morbi.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="relative bg-white mb-10 md:mb-20">
            <div class="lg:absolute lg:inset-0">
                <div class="lg:absolute lg:inset-y-0 lg:left-0 lg:w-1/2">
                    <img class="h-56 w-full object-cover lg:absolute lg:h-full"
                        src="https://images.unsplash.com/photo-1522071820081-009f0129c71c?ixlib=rb-1.2.1&auto=format&fit=crop&w=1567&q=80"
                        alt="">
                </div>
            </div>
            <div
                class="relative pt-12 pb-16 px-4 sm:pt-16 sm:px-6 lg:px-8 lg:max-w-7xl lg:mx-auto lg:grid lg:grid-cols-2">
                <div class="lg:col-start-2 lg:pl-8">
                    <div class="text-base max-w-prose mx-auto lg:max-w-lg lg:ml-auto lg:mr-0">
                        <h3
                            class="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-brSecondary-dark sm:text-4xl">
                            Terapia Online?
                        </h3>
                        <p class="mt-8 text-lg text-gray-500">Sagittis scelerisque nulla cursus in enim consectetur
                            quam. Dictum urna sed consectetur neque tristique pellentesque. Blandit amet, sed aenean
                            erat arcu morbi.</p>
                        <div class="mt-5 prose prose-indigo text-gray-500">
                            <p>Sollicitudin tristique eros erat odio sed vitae, consequat turpis elementum. Lorem nibh
                                vel, eget pretium arcu vitae. Eros eu viverra donec ut volutpat donec laoreet quam urna.
                            </p>
                            <p>Bibendum eu nulla feugiat justo, elit adipiscing. Ut tristique sit nisi lorem pulvinar.
                                Urna, laoreet fusce nibh leo. Dictum et et et sit. Faucibus sed non gravida lectus
                                dignissim imperdiet a.</p>
                            <p>Dictum magnis risus phasellus vitae quam morbi. Quis lorem lorem arcu, metus, egestas
                                netus cursus. In.</p>
                            <ul>
                                <li>Quis elit egestas venenatis mattis dignissim.</li>
                                <li>Cras cras lobortis vitae vivamus ultricies facilisis tempus.</li>
                                <li>Orci in sit morbi dignissim metus diam arcu pretium.</li>
                            </ul>
                            <p>Rhoncus nisl, libero egestas diam fermentum dui. At quis tincidunt vel ultricies.
                                Vulputate aliquet velit faucibus semper. Pellentesque in venenatis vestibulum
                                consectetur nibh id. In id ut tempus egestas. Enim sit aliquam nec, a. Morbi enim
                                fermentum lacus in. Viverra.</p>
                            <h3>How we’re different</h3>
                            <p>Tincidunt integer commodo, cursus etiam aliquam neque, et. Consectetur pretium in
                                volutpat, diam. Montes, magna cursus nulla feugiat dignissim id lobortis amet. Laoreet
                                sem est phasellus eu proin massa, lectus. Diam rutrum posuere donec ultricies non morbi.
                                Mi a platea auctor mi.</p>
                            <p>Mauris ullamcorper imperdiet nec egestas mi quis quam ante vulputate. Vel faucibus
                                adipiscing lacus, eget. Nunc fermentum id tellus donec. Ut metus odio sit sit varius non
                                nunc orci. Eu, mi neque, ornare suspendisse amet, nibh. Facilisi volutpat lectus id
                                sapien dis mauris rhoncus. Est rhoncus, interdum imperdiet ac eros, diam mauris, tortor.
                                Risus id sit molestie magna.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="bg-white max-w-7xl mx-auto sm:px-6 lg:px-8 shadow-lg mb-10 md:mb-20">
            <!-- This example requires Tailwind CSS v2.0+ -->
            <div class="max-w-7xl mx-auto py-16 px-4 sm:px-6 lg:py-24 lg:px-8 lg:grid lg:grid-cols-3 lg:gap-x-8">
                <div>
                    <h2 class="mt-2 text-3xl font-extrabold text-brSecondary-dark">{{ __('Como posso iniciar?') }}
                    </h2>
                    <p class="mt-4 text-lg text-gray-500">Ac euismod vel sit maecenas id pellentesque eu sed
                        consectetur. Malesuada adipiscing sagittis vel nulla nec.</p>
                </div>
                <div class="mt-12 lg:mt-0 lg:col-span-2">
                    <dl
                        class="space-y-10 sm:space-y-0 sm:grid sm:grid-cols-1 sm:grid-rows-4 sm:grid-flow-col sm:gap-x-6 sm:gap-y-10 lg:gap-x-8">
                        <div class="flex">
                            <div href="#" aria-current="step">
                                <span class="p-6 flex items-center text-sm font-medium">
                                    <span class="flex-shrink-0">
                                        <span
                                            class="w-10 h-10 flex items-center justify-center border-2 border-primary-900 rounded-full">
                                            <span class="text-primary-800-dark">01</span>
                                        </span>
                                    </span>
                                </span>
                            </div>
                            <div class="ml-3 flex flex-col justify-center">
                                <dt class="text-lg leading-6 font-medium text-gray-800">
                                    {{ __('Encontre um especialista') }}
                                </dt>
                                <dd class="mt-2 text-base text-gray-500">
                                    {{ __('Encontre o especialista de sua preferência na plataforma da BioReligare') }}
                                </dd>
                            </div>
                        </div>

                        <div class="flex">
                            <!-- Heroicon name: outline/check -->
                            <div href="#" aria-current="step">
                                <span class="p-6 flex items-center text-sm font-medium">
                                    <span class="flex-shrink-0">
                                        <span
                                            class="w-10 h-10 flex items-center justify-center border-2 border-primary-900 rounded-full">
                                            <span class="text-primary-800-dark">02</span>
                                        </span>
                                    </span>
                                </span>
                            </div>
                            <div class="ml-3 flex flex-col justify-center">
                                <dt class="text-lg leading-6 font-medium text-gray-800">
                                    {{ __('Escolha seu dia e horario.') }}
                                </dt>
                                <dd class="mt-2 text-base text-gray-500">
                                    {{ __('Escolha seu dia e horario preferido para agendar com o Profissional selecionado') }}
                                </dd>
                            </div>
                        </div>

                        <div class="flex">
                            <!-- Heroicon name: outline/check -->
                            <div href="#" aria-current="step">
                                <span class="p-6 flex items-center text-sm font-medium">
                                    <span class="flex-shrink-0">
                                        <span
                                            class="w-10 h-10 flex items-center justify-center border-2 border-primary-900 rounded-full">
                                            <span class="text-primary-800-dark">03</span>
                                        </span>
                                    </span>
                                </span>
                            </div>
                            <div class="ml-3 flex flex-col justify-center">
                                <dt class="text-lg leading-6 font-medium text-gray-800">
                                    {{ __('Pague com facilidade') }}
                                </dt>
                                <dd class="mt-2 text-base text-gray-500">
                                    {{ __('Selecione o método de pagamento adequado para você') }}
                                </dd>
                            </div>
                        </div>

                        <div class="flex">
                            <!-- Heroicon name: outline/check -->
                            <div href="#" aria-current="step">
                                <span class="p-6 flex items-center text-sm font-medium">
                                    <span class="flex-shrink-0">
                                        <span
                                            class="w-10 h-10 flex items-center justify-center border-2 border-primary-900 rounded-full">
                                            <span class="text-primary-800-dark">04</span>
                                        </span>
                                    </span>
                                </span>
                            </div>
                            <div class="ml-3 flex flex-col justify-center">
                                <dt class="text-lg leading-6 font-medium text-gray-800">
                                    {{ __('Realize sua sessão') }}
                                </dt>
                                <dd class="mt-2 text-base text-gray-500">
                                    {{ __('Faça sua sessão ou atendimento de qualquer lugar do mundo') }}
                                </dd>
                            </div>
                        </div>
                    </dl>
                </div>
            </div>

        </section>
        <section>
            <!--
                This example requires Tailwind CSS v2.0+

                This example requires some changes to your config:

                ```
                // tailwind.config.js
                module.exports = {
                // ...
                plugins: [
                // ...
                require('@tailwindcss/aspect-ratio'),
                ]
                }
                ```
                -->

            <div class="max-w-7xl mx-auto py-16 px-4 sm:px-6 lg:px-8">
                <div
                    class="bg-gradient-to-br to-secondary-900 from-primary-800 rounded-lg shadow-xl overflow-hidden lg:grid lg:grid-cols-2 lg:gap-4">
                    <div class="pt-10 pb-12 px-6 sm:pt-16 sm:px-16 lg:py-16 lg:pr-0 xl:py-20 xl:px-20">
                        <div class="lg:self-center">
                            <h2 class="text-3xl font-extrabold text-white sm:text-4xl">
                                <span class="block">{{ __('Você é um especialista?') }}</span>
                            </h2>
                            <p class="mt-4 text-lg leading-6 text-primary-100">Ac euismod vel sit maecenas id
                                pellentesque eu sed consectetur. Malesuada adipiscing sagittis vel nulla nec.</p>
                            <a href="{{ route('platform.register') }}"
                                class="mt-8 bg-white border border-transparent rounded-md shadow px-6 py-3 inline-flex items-center text-base font-medium text-secondary-1100 hover:bg-gray-200">
                                {{ __('Faça seu cadastro') }}</a>
                        </div>
                    </div>
                    <div class="-mt-6 aspect-w-5 aspect-h-3 md:aspect-w-2 md:aspect-h-1">
                        <img class="transform translate-x-6 translate-y-6 rounded-md object-cover object-left-top sm:translate-x-16 lg:translate-y-20"
                            src="https://tailwindui.com/img/component-images/full-width-with-sidebar.jpg"
                            alt="App screenshot">
                    </div>
                </div>
            </div>
        </section>
    </div>
</x-platform-layout>
